//---------------------------------------------------------------
// Fichero:  proyeccion.asy
// Objetivo: Representar la distancia con otro punto
// Fecha:    J.15.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(2);

// Extremos de las rectas
pair R1=(-3,2), R2=(3,2);
pair S1=(-3,0), S2=(3,0);

// Las rectas
draw(R1 -- R2);
label("$r$", R1, W);
draw(S1 -- S2);
label("$s$", S1, W);

// El segmento que marca la distancia
pair D1=(1,0), D2=(1,2);
draw(D1 -- D2, 2bp+heavygreen);
dot(D1, 3bp+heavygray);
dot(D2, 3bp+heavygray);

// El punto
dot("P", D2, N, 6bp+black);

// La proyección
dot("Q", D1, NW, 6bp+black);

// Marcamos el ángulo recto
markrightangle(D2, D1, S2, 4mm, gray);

// Lo mismo pero con otro punto
pair T1=(-1,0), T2=(-1,2);
draw(T1 -- T2, 2bp+heavygreen);
dot(T1, 3bp+heavygray);
dot(T2, 3bp+heavygray);
dot("T", T1, NW, 6bp+black);
dot("V", T2, N, 6bp+black);
markrightangle(R1, T2, T1, 4mm, gray);
