//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar un ejemplo de distancia
// Fecha:    J.15.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(1);

// Dos segmentos
pair P1=(0,0), P2=(1,3);
pair Q1=(1,0), Q2=(2,3);
draw(P1 -- P2);
draw(Q1 -- Q2);

// El segmento que marca la distancia
pair D1=(0.8333,2.5), D2=(1.733,2.2);
draw(D1 -- D2, 2bp+heavygreen);
dot(D1, 3bp+heavygray);
dot(D2, 3bp+heavygray);

// Otros segmentos
pair A1=(0.1667,0.5), A2=(1.1667,0.5);
draw(A1 -- A2, 2bp+red);
dot(A1, 3bp+heavygray);
dot(A2, 3bp+heavygray);
pair B1=(0.6667,2), B2=(1.277,0.831);
draw(B1 -- B2, 2bp+red);
dot(B1, 3bp+heavygray);
dot(B2, 3bp+heavygray);

// Los extremos
dot(P1, 4bp+black);
dot(P2, 4bp+black);
dot(Q1, 4bp+black);
dot(Q2, 4bp+black);
