//---------------------------------------------------------------
// Fichero:  mediatriz.asy
// Objetivo: Representar la propiedad de la mediatriz
// Fecha:    X.14.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// La recta base del segmento
draw((0,0) -- (8,0));

// Los extremos
dot("A", (1,0), N, 5bp+black);
dot("B", (7,0), N, 5bp+black);

// El punto medio
dot("M", (4,0), NW, 5bp+black);

// La mediatriz
draw((4,-1) -- (4,2));
label("$t$", (4,2), SE);

// Marcamos el ángulo recto
markrightangle((5,0), (4,0), (4,1), 2mm, gray);
