//---------------------------------------------------------------
// Fichero:  segmento-sol.asy
// Objetivo: Representar el eje de un segmento circular
// Fecha:    M.20.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El segmento
pair A=(0,0), B=(-1,0), C=(1,0);
draw(buildcycle(arc(A,1,0,180), B -- C));

// Calculamos el eje
path Eje = (0,-0.1) -- (0,1.1);

// Representamos el eje
draw(Eje, 2bp+deepgreen);
