//---------------------------------------------------------------
// Fichero:  sector-sol.asy
// Objetivo: Representar el eje de un sector circular
// Fecha:    M.20.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El sector
pair A=(0,0), B=(1,-1), C=(1,1);
draw(buildcycle(arc(A,B,C),C--A--B));

// Calculamos el eje
path Eje = (-0.1,0) -- (1.5,0);

// Representamos el eje
draw(Eje, 2bp+deepgreen);
