//---------------------------------------------------------------
// Fichero:  ejercicio09-sol.asy
// Objetivo: Solución del ejercicio 9
// Fecha:    L.19.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm, 5cm, false);

// Grosor de las líneas
defaultpen(1);

// Los extremos del eje de simetría
pair E1=(-4,0), E2=(4,0);

// El eje de simetría
draw(E1 -- E2);
label("$r$", E1, NE);

// La figura original
pair A1=(-2.6,0), B1=(3,0), C1=(-1,3);
draw(A1 -- B1 -- C1 -- cycle);
pen PuntoOriginal = 4bp+black;
dot("A", A1, NW, PuntoOriginal);
dot("B", B1, NE, PuntoOriginal);
dot("C", C1, N, PuntoOriginal);

// La solución
pair C2=(-1,-3);
draw(A1 -- B1 -- C2 -- cycle, deepgreen);
pen PuntoSolucion = 4bp+deepgreen;
dot("A'", A1, SW, PuntoSolucion);
dot("B'", B1, SE, PuntoSolucion);
dot("C'", C2, S, PuntoSolucion);
