//---------------------------------------------------------------
// Fichero:  ejercicio06-enu.asy
// Objetivo: Enunciado del ejercicio 6
// Fecha:    L.19.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm, 5cm, false);

// Grosor de las líneas
defaultpen(1);

// Los extremos del eje de simetría
pair E1=(-4,0), E2=(4,0);

// El eje de simetría
draw(E1 -- E2);
label("$r$", E1, NE);

// La figura original
pair A1=(-2.5,0.5), B1=(2.5,0.5);
draw(buildcycle(A1 -- B1, arc((0,0.5),2.5,0,180)));
pen PuntoOriginal = 4bp+black;
dot("A", A1, W, PuntoOriginal);
dot("B", B1, E, PuntoOriginal);

// La solución
pair A2=(-2.5,-0.5), B2=(2.5,-0.5);
draw(buildcycle(B2 -- A2, arc((0,-0.5),2.5,180,0,CCW)),white);
pen PuntoSolucion = 4bp+white;
dot("A'", A2, W, PuntoSolucion);
dot("B'", B2, E, PuntoSolucion);
