//---------------------------------------------------------------
// Fichero:  ejercicio03-sol.asy
// Objetivo: Solución del ejercicio 3
// Fecha:    L.19.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm, 5cm, false);

// Grosor de las líneas
defaultpen(1);

// Los extremos del eje de simetría
pair E1=(0,-4), E2=(0,4);

// El eje de simetría
draw(E1 -- E2);
label("$r$", E2, SE);

// La figura original
pair A1=(1,1), B1=(2,3), C1=(4,-3);
draw(A1 -- B1 -- C1 -- cycle);
pen PuntoOriginal = 4bp+black;
dot("A", A1, E, PuntoOriginal);
dot("B", B1, E, PuntoOriginal);
dot("C", C1, E, PuntoOriginal);

// La solución
pair A2=(-1,1), B2=(-2,3), C2=(-4,-3);
draw(A2 -- B2 -- C2 -- cycle, deepgreen);
pen PuntoSolucion = 4bp+deepgreen;
dot("A'", A2, W, PuntoSolucion);
dot("B'", B2, W, PuntoSolucion);
dot("C'", C2, W, PuntoSolucion);
