//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Mostrar el enunciado
// Fecha:    M.13.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos para dibujar las rectas
pair R1=(1,7), R2=(26,7);
pair S1=(1,3), S2=(26,3);
pair T1=(1,1), T2=(26,1);
pair U1=(3,8), U2=(4,0);
pair V1=(6,8), V2=(7,0);
pair W1=(21,8), W2=(17,0);

// Definición de las rectas
path r = R1 -- R2;
path s = S1 -- S2;
path t = T1 -- T2;
path u = U1 -- U2;
path v = V1 -- V2;
path w = W1 -- W2;

// Los puntos de corte de las rectas
pair A = intersectionpoint(r,u);
pair B = intersectionpoint(r,v);
pair C = intersectionpoint(r,w);
pair D = intersectionpoint(s,u);
pair E1 = intersectionpoint(s,v);
pair F = intersectionpoint(s,w);
pair G = intersectionpoint(t,u);
pair H = intersectionpoint(t,v);
pair I = intersectionpoint(t,w);

// Las rectas
draw(r); draw(s); draw(t); draw(u); draw(v); draw(w);

// Los nombres de las rectas
label("$r$", R1, W);
label("$s$", S1, W);
label("$t$", T1, W);
label("$u$", U1, W);
label("$v$", V1, W);
label("$w$", W1, E);

// Los puntos
dot(Label("A"), A, NE);
dot(Label("B"), B, NE);
dot(Label("C"), C, NW);
dot(Label("D"), D, NE);
dot(Label("E"), E1, NE);
dot(Label("F"), F, NW);
dot(Label("G"), G, NE);
dot(Label("H"), H, NE);
dot(Label("I"), I, NW);
