//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Mostrar la solución
// Fecha:    V.9.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = -11, Xmax = 11, Ymin = -5, Ymax = 7, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(-10,6), B=(10,-2), C=(-6,-4), D=(-3,5), E1=(4,-3);
pair F=(7,6), G=(0,2), H=(-5,-1), I=(5,0), J=(6,3), K=(-4,2);
pair L=(-5,4), M=(8,4), N1=(3,5);

// Definición de los puntos para dibujar las rectas
pair R1=(-10.47,6.19), R2=(10.45,-2.18);
pair S1=(-6.21,-4.62), S2=(-2.58,6.26);
pair T1=(3.6,-4.2), T2=(7.16,6.49);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, W, 5pt+black);
dot(Label("D"), D, NW, 5pt+black);
dot(Label("E"), E1, W, 5pt+black);
dot(Label("F"), F, NW, 5pt+black);
dot(Label("G"), G, NE, 5pt+black);
dot(Label("H"), H, SE, 5pt+black);
dot(Label("I"), I, NW, 5pt+black);
dot(Label("J"), J, NW, 5pt+black);
dot(Label("K"), K, SE, 5pt+black);
dot(Label("L"), L, SW, 5pt+black);
dot(Label("M"), M, E, 5pt+black);
dot(Label("N"), N1, S, 5pt+black);

// Las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);

// Los nombres de las rectas
label("$r$", (2.5,1), N);
label("$s$", (-4.8,0.8), N);
label("$t$", (4.5,-1.5), W);
