//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Mostrar el enunciado
// Fecha:    S.10.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(-5,1), B=(1,4), C=(4,0), D=(0,2), E1=(-8,1.33);
pair F=(-7,0), G=(0,5.33), H=(3,5), I=(5,-0.11), J=(5,-1.33);

// Definición de los puntos para dibujar las rectas
pair R1=(-8,-0.5), R2=(6,6.5);
pair S1=(-0.5,6), S2=(5.5,-2);
pair T1=(-8.59,1.4), T2=(6,-0.22);

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, SW, 5pt+black);
dot(Label("D"), D, NW, 5pt+black);
dot(Label("E"), E1, N, 5pt+black);
dot(Label("F"), F, SE, 5pt+black);
dot(Label("G"), G, NE, 5pt+black);
dot(Label("H"), H, SE, 5pt+black);
dot(Label("I"), I, NE, 5pt+black);
dot(Label("J"), J, SW, 5pt+black);

// Las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);

// Los nombres de las rectas
label("$r$", (-2.5,2.5));
label("$s$", (2.5,2.5));
label("$t$", (0,0));
