//---------------------------------------------------------------
// Fichero:  semirregular.asy
// Objetivo: Representar un teselado semirregular 3464
// Fecha:    M.29.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xlimits()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.2cm);

// Grosor de las líneas
defaultpen(1);

// Factor de escalado del dodecágono
real Factor=sqrt(2*(1-Cos(150)));

// Desplazamiento horizontal entre dos patrones
real DesHor=1+2*Cos(30);

// Desplazamiento vertical entre dos patrones
real DesVer=1.5+Cos(30);

// Función que dibuja un patrón básico
void DibujaPatron(pair Centro)
    {
    // El hexágono regular interno
    path Hexagono=shift(Centro)*rotate(30)*polygon(6);
    draw(Hexagono);

    // El dodecágono regular externo
    path Dodecagono=shift(Centro)*scale(Factor)*rotate(30)*polygon(12);
    draw(Dodecagono);

    // Las líneas que forman los cuadrados y los triángulos
    for ( int i=0 ; i<6 ; ++i )
        {
        draw(point(Hexagono,i) -- point(Dodecagono,2*i));
        draw(point(Hexagono,i) -- point(Dodecagono,2*i+1));
        }
    }

// Repetimos el patrón
for ( int i=0 ; i<6 ; ++i )
    {
    for ( int j=0 ; j<4 ; ++j )
        { DibujaPatron((DesHor*(i+(j%2)*0.5),DesVer*j)); }
    }

// Recortamos la parte que se ve
xlimits(0,5*DesHor,Crop);
