//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Ejemplo 1
// Fecha:    X.23.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 6, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.5bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.1mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Marcamos en gris todos los puntos de coordenadas enteras
for ( int i=0 ; i<=Xmax ; ++i )
    {
    for ( int j=0 ; j<=Ymax ; ++j )
        { dot((i,j), 3bp+gray);}
    }

// Definición de los vértices
pair A=(1,3), B=(9,1), C=(9,5);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos del perímetro
pair Perimetro[] = {A, B, C, (5,2), (5,4), (9,2), (9,3), (9,4) };
for ( int i=0 ; i<Perimetro.length ; ++i )
    { dot(Perimetro[i], 3bp+red); }

// Los puntos del interior
pair Interior[] = {(2,3), (3,3), (4,3), (5,3), (6,3), (7,3), (8,3),
                   (6,4), (7,4), (8,4), (6,2), (7,2), (8,2) };
for ( int i=0 ; i<Interior.length ; ++i )
    { dot(Interior[i], 3bp+heavygreen); }
