//---------------------------------------------------------------
// Fichero:  descomposicion.asy
// Objetivo: Descomposición de un polígono regular
// Fecha:    M.22.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definción del polígono
path Poligono=polygon(5);

// Los radios
for ( int i=0 ; i<5 ; ++i )
    {
    draw((0,0) -- point(Poligono, i), gray);
    }

// El polígono
draw(Poligono);

// El triángulo de más abajo
pair A1=point(Poligono,4), B1=point(Poligono,0), C1=(0,0);

// Punto medio de la base
pair MB=(A1+B1)/2;

// Una flecha
draw((1.25,0) -- (1.75,0), 0.5mm+deepgreen,Arrow(size=2.5mm));

// Separamos uno de los triángulos
transform t=shift(2.5,0.3);
pair A2=t*A1, B2=t*B1, C2=t*C1;

// Punto medio de la base
pair M=(A2+B2)/2;

// La altura
draw(M -- C2, gray);

// Marcamos el ángulo recto
markrightangle(C2, M, A2, 2mm, 0.5bp+gray);

// El triángulo
draw(A2 -- B2 -- C2 -- cycle);

// Nombres
label("Lado", MB, S, blue);
label("Lado", M, S, blue);
label(shift(8*(Cos(126),Sin(126)))*rotate(54,A1)*"Radio", (A1+C1)/2, blue);
label(shift(8*(Cos(126),Sin(126)))*rotate(54,A1)*"Radio", (A2+C2)/2, blue);
label(shift(8*(Cos(54),Sin(54)))*rotate(-54,B1)*"Radio", (B1+C1)/2, blue);
label(shift(8*(Cos(54),Sin(54)))*rotate(-54,B1)*"Radio", (B2+C2)/2, blue);
label(Label(rotate(90)*"Apotema", fontsize(6pt)+blue), (M+C2)/2, (1,-0.4));
