//---------------------------------------------------------------
// Fichero:  lados5ac.asy
// Objetivo: Ángulo central de un polígono regular de 5 lados
// Fecha:    D.20.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,2cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Poligono=polygon(5);
draw(Poligono);

// Dos vértices
pair V1=point(Poligono,2);
pair V2=point(Poligono,3);

// El ángulo
markangle(radius=3mm, V1, (0,0), V2, 2bp+blue);

// Los radios
draw(V1 -- (0,0) -- V2, 1bp+gray);

// Los puntos
dot((0,0), 2bp+black);
dot(V1,2bp+black);
dot(V2,2bp+black);

