//---------------------------------------------------------------
// Fichero:  lados3ci.asy
// Objetivo: Circunferencia inscrita en un polígono regular de 4 lados
// Fecha:    D.20.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,2cm);

// Grosor de las líneas
defaultpen(1);

// Número de lados
int n=4;

// La circunferencia
draw(circle((0,0),Cos(360/2/n)), 1bp+blue);

// El polígono
path Poligono=polygon(n);
draw(Poligono);

// Los puntos medios de los lados
for ( int i=0 ; i<n ; ++i )
    {
    pair V1=point(Poligono,i);
    pair V2=point(Poligono,i+1);
    dot((V1+V2)/2,3bp+black);
    }
