//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Enunciado
// Fecha:    J.17.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices exteriores
pair A1=(0,0), B1=(21,0), C1=(21,8), D1=(0,8);

// El polígono exterior
path Ext= A1-- B1 -- C1 -- D1 -- cycle;

// Los vértices interiores
pair A2=(1,1), B2=(8,1), C2=(8,7), D2=(1,7);

// El polígono interior
path Int= A2 -- B2 -- C2 -- D2 -- cycle;

// El conjunto de polígonos
path[] Conjunto={Ext,Int};

// El dibujo
filldraw(Conjunto,mediumgray+evenodd,black);

// Las medidas
label(Dist(A1,B1), (A1+B1)/2, S, blue);
label(Dist(A2,B2), (A2+B2)/2, N, blue);
label(Dist(B1,C1), (B1+C1)/2, E, blue);
label(Dist(B2,C2), (B2+C2)/2, W, blue);
