//---------------------------------------------------------------
// Fichero:  lados6ejemplo3.asy
// Objetivo: Polígono de 6 lados, ejemplo 3
// Fecha:    S.12.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,1.6cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Poligono=polygon(6);
guide Camino;
for (int i=0; i<6; ++i)
    {
    if ( i%2>0 ) { Camino = Camino -- point(Poligono,i); }
    else         { Camino = Camino -- 0.3*point(Poligono,i); }
    }
path Hexagono=Camino -- cycle;
draw(rotate(30)*Hexagono);
