//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Representar un polígono con su notación
// Fecha:    V.11.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,3), C=(16,1), D=(13,7), E1=(1,5);

// El polígono
draw(A -- B -- C -- D -- E1 -- cycle);

// Los vértices
dot("A", A, SW, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, SE, 3bp+black);
dot("D", D, N, 3bp+black);
dot("E", E1, NW, 3bp+black);

// Los lados
label("f", (A+B)/2, S);
label("g", (B+C)/2, S);
label("h", (C+D)/2, E);
label("i", (D+E1)/2, N);
label("j", (A+E1)/2, W);

// Los ángulos
pen FormAng=fontsize(8pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng), radius=6mm, B, A, E1, FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng), radius=3mm, C, B, A, FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng), radius=5mm, D, C, B, FormArc);
markangle(Label("$\hat{\textup{D}}$",FormAng), radius=3mm, E1, D, C, FormArc);
markangle(Label("$\hat{\textup{E}}$",FormAng), radius=3mm, A, E1, D, FormArc);
