//---------------------------------------------------------------
// Fichero:  diagonalessimple.asy
// Objetivo: Representar las diagonales de un polígono simple
// Fecha:    J.10.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(12,-1), C=(10,3), D=(8,1), E1=(2,2);

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(A -- C, Punteado+blue);
draw(A -- D, Punteado+blue);
draw(B -- D, Punteado+blue);
draw(B -- E1, Punteado+blue);
draw(C -- E1, Punteado+blue);

// El polígono
draw(A -- B -- C -- D -- E1 -- cycle);

dot("A", A, SW, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, N, 3bp+black);
dot("E", E1, NW, 3bp+black);
