//---------------------------------------------------------------
// Fichero:  conjunto.asy
// Objetivo: Representar un conjunto de rombos de Penrose
// Fecha:    S.26.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(17cm);

// Grosor de las líneas
defaultpen(4);

// Función que dibuja un rombo de Penrose dado el punto derecho más bajo
pair[] RomboPenrose(pair Base)
    {
    // Los vértices
    pair A=Base+(-1,0), B=Base,
         C=Base+(Cos(72),Sin(72)), D=A+(C-B);

    // El punto auxiliar
    pair Q=extension(B, B+(Cos(108),Sin(108)), A, C);

    // Las diagonales de las piezas
    pen Punteado = linetype(new real[] {2,2});
    draw(C -- Q, Punteado+gray);
    draw(B -- D, Punteado+gray);

    // El rombo
    draw(A -- B -- C -- D -- cycle);

    // Las líneas auxiliares
    draw(D -- Q -- B);

    // El resultado de la función son los dos vértices vecinos a la base
    pair Respuesta[] = {A, C};
    return Respuesta;
    }

// Los rombos
pair V[] = RomboPenrose((0,0));
RomboPenrose(V[0]);
pair W[] = RomboPenrose(V[1]);
RomboPenrose(W[0]);
pair X[] = RomboPenrose(W[1]);
RomboPenrose(X[0]);
