//---------------------------------------------------------------
// Fichero:  enunciado4.asy
// Objetivo: Enunciado 4
// Fecha:    V.18.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que marca un segmento entre dos puntos
void Segmento(pair A, pair B)
    {
    dot(A, 2bp+red);
    dot(B, 2bp+red);
    draw(A -- B, 0.75bp+red);
    }

// Constantes
int NumRombos=7, CatMenor=36, CatMayor=77, Separacion=35;

// Los vértices exteriores
int Anchura=NumRombos*2*CatMenor+(NumRombos+1)*Separacion;
int Altura=2*(CatMayor+Separacion);
pair A=(0,0), B=(Anchura,0), C=(Anchura,Altura), D=(0,Altura);

// El polígono exterior
filldraw(A-- B -- C -- D -- cycle, mediumgray, black);

// Los rombos
for ( int i=0 ; i<NumRombos ; ++i )
    {
    pair A=((2*CatMenor+Separacion)*i+Separacion+CatMenor,Separacion);
    pair B=A+(CatMenor,CatMayor);
    pair C=A+(0,2*CatMayor);
    pair D=B+(-2*CatMenor,0);
    filldraw(A-- B -- C -- D -- cycle, white, black);
    Segmento(A, (A.x,0));
    Segmento(C, (C.x,Altura));
    Segmento(B, B+(Separacion,0));
    Segmento(D, D-(Separacion,0));
    }
