//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Enunciado 10
// Fecha:    L.21.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(0,0), B=(5,0), C=(5,2), D=(2,2), E1=(2,4), F=(5,4),
     G=(5,5), H=(0,5);

// El polígono
draw(A -- B -- C -- D -- E1 -- F -- G -- H -- cycle);

// Las medidas
label(Dist(A,H), (A+H)/2, W, blue);
label(Dist(G,H), (G+H)/2, N, blue);
label(Dist(C,D), (C+D)/2, N, blue);
