//---------------------------------------------------------------
// Fichero:  triangular.asy
// Objetivo: Dibujar una rejilla triangular
// Fecha:    V.25.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Constantes
int TotFil = 7, TotCol = 11;
real Altura=sqrt(3)/2;

// Los puntos
for ( int i=0 ; i<TotCol ; ++i )
    {
    for ( int j=0 ; j<TotFil ; ++j )
        { dot((i+j%2*0.5,j*Altura),3bp+heavygray); }
    }
