//---------------------------------------------------------------
// Fichero:  solucion6.asy
// Objetivo: Solución 6
// Fecha:    V.25.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Constantes
int TotFil = 7, TotCol = 11;
real Altura=sqrt(3)/2;

// Función que dibuja triángulo dado el vértice superior
void DibujaTrianguloBajo(pair A)
    {
    pair B=A+(0.5,-Altura), C=A+(-0.5,-Altura);
    draw(A -- B -- C -- cycle,heavygreen);
    dot(A,3bp+deepgreen);
    dot(B,3bp+deepgreen);
    dot(C,3bp+deepgreen);
    }

// Función que dibuja triángulo dado el vértice inferior
void DibujaTrianguloSobre(pair A)
    {
    pair B=A+(0.5,Altura), C=A+(-0.5,Altura);
    draw(A -- B -- C -- cycle,heavygreen);
    dot(A,3bp+deepgreen);
    dot(B,3bp+deepgreen);
    dot(C,3bp+deepgreen);
    }

// Función que dibuja un hexágono de la solución
void DibujaHexagono(pair A)
    {
    pair B=A+(1,0), C=A+(1.5,Altura), D=A+(1,2*Altura), E=D+(-1,0), F=C+(-2,0);
    draw(A -- B -- C -- D -- E -- F -- cycle,heavygreen);
    dot(A,3bp+deepgreen);
    dot(B,3bp+deepgreen);
    dot(C,3bp+deepgreen);
    dot(D,3bp+deepgreen);
    dot(E,3bp+deepgreen);
    dot(F,3bp+deepgreen);
    DibujaTrianguloBajo(A);
    DibujaTrianguloBajo(B);
    DibujaTrianguloBajo(C);
    DibujaTrianguloBajo(F);
    DibujaTrianguloSobre(C);
    DibujaTrianguloSobre(D);
    DibujaTrianguloSobre(E);
    DibujaTrianguloSobre(F);
    pair Q=B+(A-F); DibujaTrianguloSobre(Q);
    pair R=A+(B-C); DibujaTrianguloSobre(R);
    pair S=B+(1,0); DibujaTrianguloSobre(S);
    pair T=A+(-1,0); DibujaTrianguloSobre(T);
    pair U=D+(1,0); DibujaTrianguloBajo(U);
    pair V=E+(-1,0); DibujaTrianguloBajo(V);
    pair W=D+(C-B); DibujaTrianguloBajo(W);
    pair X=E+(D-C); DibujaTrianguloBajo(X);
    }

// Los puntos básicos
for ( int i=0 ; i<TotCol ; ++i )
    {
    for ( int j=0 ; j<TotFil ; ++j )
        { dot((i+j%2*0.5,j*Altura),3bp+heavygray); }
    }

// Los hexágonos
DibujaHexagono((1.5,3*Altura));
DibujaHexagono((4,2*Altura));
DibujaHexagono((6.5,3*Altura));
