//---------------------------------------------------------------
// Fichero:  enunciado5.asy
// Objetivo: Enunciado 5
// Fecha:    X.23.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
int Xmin = 0, Xmax = 8, Ymin = 0, Ymax = 5;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.5bp+gray));

// Grosor de las líneas
defaultpen(1);

// Marcamos en gris todos los puntos de coordenadas enteras
for ( int i=Xmin ; i<=Xmax ; ++i )
    {
    for ( int j=Ymin ; j<=Ymax ; ++j )
        { dot((i,j), 3bp+gray);}
    }

// Los vértices
pair V[]={(0,0), (4,2), (8,0), (8,5), (4,3), (0,5)};

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);

// Los vértices
for ( int i=0 ; i<V.length ; ++i )
    { dot(V[i], 3bp+black); }
