//---------------------------------------------------------------
// Fichero:  enunciado06.asy
// Objetivo: Representar el enunciado 6
// Fecha:    D.20.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Número de lados
int n=9;

// El polígono
path Poligono=polygon(n);

// Definición de los vértices
pair V0=point(Poligono,0), V1=point(Poligono,1), V2=V0+(0.5,0);

// El ángulo
draw(V0 -- V2, 1bp+heavygray);
markangle("$\alpha$", radius=5mm, V2, V0, V1, 0.5bp+blue);

// El polígono
draw(Poligono);
