//---------------------------------------------------------------
// Fichero:  enunciado15.asy
// Objetivo: Representar el enunciado 15
// Fecha:    L.14.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V)+1)+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// El polígono
path Regular=polygon(7);
guide Camino;
for (int i=0; i<7; ++i)
    { Camino = Camino -- point(Regular,i); }
path Poligono=Camino -- cycle;

// Definición de los vértices
pair V[];
for (int i=0; i<length(Poligono); ++i)
    {
    if ( i==5 ) { V[i] = point(Poligono,i)-(0.25,0.3); }
    else        { V[i] = point(Poligono,i); };
    }
V.cyclic=true;

// Los ángulos
for ( int i=0; i<4; ++i )
    { markangle("$\alpha$", radius=4mm, V[i+1], V[i], V[i-1], 0.5bp+blue); }

for (int i=4; i<V.length; ++i)
    {
    int Correccion = 1;
    if ( i == 6 ) { Correccion = 0; }
    markangle(Ang(V[i+1], V[i], V[i-1], Correccion), radius=4mm,
                V[i+1], V[i], V[i-1], 0.5bp+blue);
    }

// El polígono
guide Camino;
for (int i=0; i<7; ++i)
    { Camino = Camino -- V[i]; }
path Poligono=Camino -- cycle;
draw(Poligono);
