//---------------------------------------------------------------
// Fichero:  enunciado13.asy
// Objetivo: Representar el enunciado 13
// Fecha:    L.14.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(8,-5), B=(6,0), C=(9,6), D=(-8,5), E=(-6,0), F=(-9,-6);

// Los ángulos
markangle("$\alpha$", radius=2mm, A, B, C, 0.5bp+blue);
markangle(Ang(B,A,F,0), radius=4mm, B, A, F, 0.5bp+blue);
markangle(Ang(D,C,B,0), radius=4mm, D, C, B, 0.5bp+blue);
markangle(Ang(E,D,C,1), radius=4mm, E, D, C, 0.5bp+blue);
markangle("$\alpha$", radius=2mm, D, E, F, 0.5bp+blue);
markangle(Ang(A,F,E,0), radius=4mm, A, F, E, 0.5bp+blue);

// El polígono
draw(A -- B -- C -- D -- E -- F -- cycle);
