//---------------------------------------------------------------
// Fichero:  convexa.asy
// Objetivo: Representar una figura convexa
// Fecha:    J.8.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// La figura
draw((0,0) -- (4,-3) -- (8,1) -- (6,4) -- (1,2) -- cycle);

// Definición de los puntos
pair A=(1,1), B=(6,3), C=(4,-2), D=(2,0.8), E=(4.5,-0.5), F=(6,1.5);

// Las líneas
draw(A -- B, heavygreen);
draw(C -- D, heavygreen);
draw(E -- F, heavygreen);

// Los puntos
dot(A, 4bp+blue);
dot(B, 4bp+blue);
dot(C, 4bp+blue);
dot(D, 4bp+blue);
dot(E, 4bp+blue);
dot(F, 4bp+blue);
