//---------------------------------------------------------------
// Fichero:  concava.asy
// Objetivo: Representar una figura cóncava
// Fecha:    D.13.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// La figura
draw((0,0) -- (4,-3) -- (8,1) -- (4,0) -- (1,3) -- cycle);

// Definición de los puntos
pair A=(1.1,2.5), B=(7,0.5), C=(4,-2), D=(1.5,0.3), E=(4.2,-0.8), F=(6.5,0);

// Las líneas
draw(A -- B, heavyred);
draw(C -- D, heavygreen);
draw(E -- F, heavygreen);

// Los puntos
dot(A, 4bp+deepmagenta);
dot(B, 4bp+deepmagenta);
dot(C, 4bp+blue);
dot(D, 4bp+blue);
dot(E, 4bp+blue);
dot(F, 4bp+blue);
