//---------------------------------------------------------------
// Fichero:  demostracion2.asy
// Objetivo: Segundo paso de la demostración
// Fecha:    V.4.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair C=(-3,0), D=(3,0), E1=(1.5,2), F=(-1.5,2);

// Los puntos proyección
pair Q=(-1.5,0), R=(1.5,0);

// Los ángulos rectos
markrightangle(F, Q, C, 3mm, 0.5bp+gray);
markrightangle(D, R, E1, 3mm, 0.5bp+gray);

// El trapecio
draw(C -- D -- E1 -- F -- cycle);

// Las alturas
draw(F -- Q, heavygray);
draw(E1 -- R, heavygray);

// Los puntos
dot("C", C, SW, 3bp+black);
dot("D", D, SE, 3bp+black);
dot("E", E1, NE, 3bp+black);
dot("F", F, NW, 3bp+black);
dot("Q", Q, NE, 3bp+black);
dot("R", R, NW, 3bp+black);

// Los textos
label("$B$", (C+D)/2, S, blue);
label("$b$", (E1+F)/2, N, blue);
label("$x$", (C+F)/2, W, blue);
label("$x$", (E1+D)/2, E, blue);
label("$h$", (E1+R)/2, W, blue);
label("$h$", (F+Q)/2, E, blue);
