//---------------------------------------------------------------
// Fichero:  trapeciorectangulo.asy
// Objetivo: Representar un trapecio rectángulo
// Fecha:    X.2.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(4,3), D=(0,3);

// Los ángulos rectos
markrightangle(B, A, D, 3mm, 0.5bp+gray);
markrightangle(A, D, C, 3mm, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot("A", A, SW, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);
