//---------------------------------------------------------------
// Fichero:  demostracion3.asy
// Objetivo: Tercer paso de la demostración
// Fecha:    X.2.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair D=(6,0), E1=(4,3), Q=(4,0);

// El ángulo recto
markrightangle(D, Q, E1, 3mm, 0.5bp+gray);

// El triángulo
draw(E1 -- Q -- D -- cycle);

// Los puntos
dot("D", D, SE, 3bp+black);
dot("E", E1, N, 3bp+black);
dot("Q", Q, SW, 3bp+black);

// Los textos
label("$B-b$", (Q+D)/2, S, blue);
label("$h$", (E1+Q)/2, W, blue);
label("$x$", (E1+D)/2, E, blue);
