//---------------------------------------------------------------
// Fichero:  demostracion1.asy
// Objetivo: Primer paso de la demostración
// Fecha:    X.2.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair C=(0,0), D=(6,0), E1=(4,3), F=(0,3);

// Los ángulos rectos
markrightangle(D, C, F, 3mm, 0.5bp+gray);
markrightangle(C, F, E1, 3mm, 0.5bp+gray);

// El trapecio
draw(C -- D -- E1 -- F -- cycle);

// Los puntos
dot("C", C, SW, 3bp+black);
dot("D", D, SE, 3bp+black);
dot("E", E1, NE, 3bp+black);
dot("F", F, NW, 3bp+black);

// Los textos
label("$B$", (C+D)/2, S, blue);
label("$b$", (E1+F)/2, N, blue);
label("$h$", (C+F)/2, W, blue);
label("$x$", (E1+D)/2, E, blue);
