//---------------------------------------------------------------
// Fichero:  demostracion3.asy
// Objetivo: Tercer paso de la demostración
// Fecha:    M.1.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta de tamaño determinado
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Definición de los vértices
pair C=(0,0), D=(8,0), E1=(7,3), F=(3,3), G=D, H=(12,0), I=(15,3), J=E1;

// Las alturas
pair P=(4,0), Q=(4,3);
draw(P -- Q, blue);
pair R=(10,0), S1=(10,3);
draw(R -- S1, blue);

// Los trapecios
draw(C -- D -- E1 -- F -- cycle);
draw(G -- H -- I -- J -- cycle);

// Los puntos
dot("C", C, SW, 3bp+black);
dot("F", F, NW, 3bp+black);
dot("H", H, SE, 3bp+black);
dot("I", I, NE, 3bp+black);
dot(P, 3bp+black);
dot(Q, 3bp+black);

// Los ángulos rectos
markrightangle(C, P, Q, 2mm, 0.5bp+gray);
markrightangle(F, Q, P, 2mm, 0.5bp+gray);
markrightangle(F, S1, R, 2mm, 0.5bp+gray);
markrightangle(C, R, S1, 2mm, 0.5bp+gray);

// Las flechas que marcan las dimensiones
real Separacion = 0.3;
draw((0,-Separacion) -- (8,-Separacion),
     blue, Arrows(HookHead,5bp));
draw((8,-Separacion) -- (12,-Separacion),
     blue, Arrows(HookHead,5bp));
draw((3,3+Separacion) -- (7,3+Separacion),
     blue, Arrows(HookHead,5bp));
draw((7,3+Separacion) -- (15,3+Separacion),
     blue, Arrows(HookHead,5bp));

// Los textos
label(Eti("$B$"), (C+D)/2, 3*S);
label(Eti("$B$"), (I+J)/2, 3*N);
label(Eti("$b$"), (E1+F)/2, 3*N);
label(Eti("$b$"), (G+H)/2, 3*S);
label(Eti("$h$"), (P+Q)/2, E);
label(Eti("$h$"), (R+S1)/2, E);
