//---------------------------------------------------------------
// Fichero:  demostracion2.asy
// Objetivo: Segundo paso de la demostración
// Fecha:    M.1.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta de tamaño determinado
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Definición de los vértices
pair G=(0,0), H=(4,0), I=(6,3), J=(-1,3);

// La altura
pair P=(2,0), Q=(2,3);
draw(P -- Q, blue);

// El trapecio
draw(G -- H -- I -- J -- cycle);

// Los puntos
dot("G", G, SW, 3bp+black);
dot("H", H, SE, 3bp+black);
dot("I", I, NE, 3bp+black);
dot("J", J, NW, 3bp+black);
dot(P, 3bp+black);
dot(Q, 3bp+black);

// Los ángulos rectos
markrightangle(G, P, Q, 2mm, 0.5bp+gray);
markrightangle(J, Q, P, 2mm, 0.5bp+gray);

// Las flechas que marcan las dimensiones
real Separacion = 0.3;
draw((0,-Separacion) -- (4,-Separacion),
     blue, Arrows(HookHead,5bp));
draw((-1,3+Separacion) -- (6,3+Separacion),
     blue, Arrows(HookHead,5bp));

// Los textos
label(Eti("$B$"), (I+J)/2, 3*N);
label(Eti("$b$"), (G+H)/2, 3*S);
label(Eti("$h$"), (P+Q)/2, E);
