//---------------------------------------------------------------
// Fichero:  demostracion2.asy
// Objetivo: Demostración de la propiedad del rombo
// Fecha:    J.27.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices del triángulo
pair Q=(0,6), R=(12,0), M=(0,0);

// El ángulo recto
markrightangle(R, M, Q, 4mm, 0.5bp+gray);

// El triángulo
draw(Q -- R -- M -- cycle);

// Los puntos
dot("Q", Q, N, 3bp+black);
dot("R", R, E, 3bp+black);
dot("M", M, SW, 3bp+black);

// Los textos
label("$a$", (Q+R)/2, NE, blue);
label("$d:2$", (M+R)/2, S, blue);
label("$g:2$", (Q+M)/2, W, blue);
