//---------------------------------------------------------------
// Fichero:  demostracion1.asy
// Objetivo: Demostración de la propiedad del rombo
// Fecha:    J.27.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices del rombo
pair Q=2*(0,3), R=2*(6,0), S1=2*(0,-3), T=2*(-6,0);

// El centro
pair M=(0,0);

// El ángulo recto
markrightangle(R, M, Q, 2mm, 0.5bp+gray);

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(Q -- S1, Punteado+blue);
draw(T -- R, Punteado+blue);

// El rombo
draw(Q -- R -- S1 -- T -- cycle);

// Los puntos
dot("Q", Q, N, 3bp+black);
dot("R", R, E, 3bp+black);
dot("S", S1, S, 3bp+black);
dot("T", T, W, 3bp+black);
dot("M", M, SW, 3bp+black);

// Las flechas que marcan las dimensiones
draw(2*(-6,-5) -- 2*(6,-5), blue, Arrows(HookHead,5bp));
draw(2*(8,-3) -- 2*(8,3), blue, Arrows(HookHead,5bp));

// Los textos
label("$a$", (Q+R)/2, NE, blue);
label("$d$", 2*(0,-6), blue);
label("$g$", 2*(9,0), blue);
