//---------------------------------------------------------------
// Fichero:  demostracion.asy
// Objetivo: Demostración del área del rombo
// Fecha:    X.26.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices del rombo
pair A=(0,-3), B=(6,0), C=(0,3), D=(-6,0);

// Los vértices del rectángulo
pair E1=(-6,-3), F=(6,-3), G=(6,3), H=(-6,3);

// El centro
pair M=(A+C)/2;

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(A -- C, Punteado+blue);
draw(B -- D, Punteado+blue);

// Las figuras
draw(A -- B -- C -- D -- cycle);
draw(E1 -- F -- G -- H -- cycle);

// Los puntos
dot("A", A, S, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("D", D, W, 3bp+black);
dot("M", M, SE, 3bp+black);
dot("E", E1, SW, 3bp+black);
dot("F", F, SE, 3bp+black);
dot("G", G, NE, 3bp+black);
dot("H", H, NW, 3bp+black);

// Las flechas que marcan las dimensiones
draw((-6,-5) -- (6,-5), blue, Arrows(HookHead,5bp));
draw((8,-3) -- (8,3), blue, Arrows(HookHead,5bp));

// Los textos
label("$d$", (0,-6), blue);
label("$g$", (9,0), blue);
