//---------------------------------------------------------------
// Fichero:  paso3.asy
// Objetivo: Representar el tercer paso de la demostración
// Fecha:    M.25.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(8,2), D=(2,2);

// La altura
pair Q=(3,2), R=(3,0);
draw(Q -- R, blue);

// Puntos auxiliares
pair U=(2,0), V=(8,0);

// El cuadrilátero
draw(U -- D -- C -- V -- cycle);

// Los puntos
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);
dot("U", U, SW, 3bp+black);
dot("V", V, SE, 3bp+black);
dot(Q, 3bp+black);
dot(R, 3bp+black);

// Los ángulos rectos
markrightangle(B, R, Q, 2mm, 0.5bp+gray);
markrightangle(C, Q, R, 2mm, 0.5bp+gray);

// Las flechas que marcan las dimensiones
real Separacion = 0.3;
draw((2,-Separacion) -- (8,-Separacion),
     blue, Arrows(HookHead,5bp));

// Los textos
label("base", (U+V)/2, 3*S, blue);
label("altura", (Q+R)/2, E, blue);
