//---------------------------------------------------------------
// Fichero:  paralelogramo.asy
// Objetivo: Representar un paralelogramo
// Fecha:    M.25.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(8,3), D=(2,3);

// El centro
pair M=(A+C)/2;

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(A -- C, Punteado+blue);
draw(B -- D, Punteado+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot("A", A, SW, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);
dot("M", M, 1.5*S+0.5*W, 3bp+black);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=3, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- B, FormExt);
draw(D -- C, FormExt);

marker FormInt = StickIntervalMarker(i=1, n=2, angle=135, size=2.5mm,
                                    space=1mm, p=red);
draw(A -- D, FormInt);
draw(B -- C, FormInt);
