//---------------------------------------------------------------
// Fichero:  basealtura.asy
// Objetivo: Representar la base y la altura de un paralelogramo
// Fecha:    M.25.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(8,3), D=(2,3);

// La altura
pair P=(3,0), Q=(3,3);
draw(P -- Q, blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
dot(D, 3bp+black);
dot(P, 3bp+black);
dot(Q, 3bp+black);

// Los ángulos rectos
markrightangle(A, P, Q, 0.5bp+gray);
markrightangle(D, Q, P, 0.5bp+gray);

// Las flechas que marcan las dimensiones
real Separacion = 0.3;
draw((0,-Separacion) -- (6,-Separacion),
     blue, Arrows(HookHead,5bp));

// Los textos
label("base", (A+B)/2, 3*S, blue);
label("altura", (P+Q)/2, E, blue);
