//---------------------------------------------------------------
// Fichero:  rectangulo.asy
// Objetivo: Representar un rectángulo
// Fecha:    L.24.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(6,3), D=(0,3);

// El centro
pair M=(A+C)/2;

// Los ángulos rectos
markrightangle(D, A, B, 0.5bp+gray);
markrightangle(C, B, A, 0.5bp+gray);
markrightangle(D, C, B, 0.5bp+gray);
markrightangle(C, D, A, 0.5bp+gray);

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(A -- C, Punteado+blue);
draw(B -- D, Punteado+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los vértices
dot("A", A, SW, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);
dot("M", M, S, 3bp+black);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=3, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- B, FormExt);
draw(D -- C, FormExt);

marker FormInt = StickIntervalMarker(i=1, n=2, angle=135, size=2.5mm,
                                    space=1mm, p=red);
draw(A -- D, FormInt);
draw(B -- C, FormInt);
