//---------------------------------------------------------------
// Fichero:  perimetroarea.asy
// Objetivo: Ilustrar el perímetro y área de un rectángulo
// Fecha:    L.24.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(grid(4,3,1bp+gray));

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(4,3), D=(0,3);

// El rectángulo
draw(A -- B -- C -- D -- cycle);

// La numeración
int k=1;
for ( int i=2 ; i>=0 ; i=i-1 )
    {
    for ( int j=0 ; j<4 ; ++j, ++k )
        { label(Label(string(k), fontsize(8pt)+gray), (j+0.5,i+0.5)); }
    }

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan las dimensiones
draw((-Separacion,0) -- (-Separacion,3),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-Separacion) -- (4,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las dimensiones
label("4 m", (2,-2*Separacion), fontsize(10pt));
label("3 m", (-2*Separacion,1.5), fontsize(10pt));
