//---------------------------------------------------------------
// Fichero:  concavodividido.asy
// Objetivo: Representar un cuadrilátero cóncavo dividido
// Fecha:    V.21.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(-2,-2.5), C=(7,1), D=(-1,3);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// La diagonal
draw(A -- C);

// Los nombres de los triángulos
label("T1", (A+B+C)/3, deepmagenta);
label("T2", (A+D+C)/3, deepmagenta);

// Los vértices
dot("A", A, W, 3bp+black);
dot("B", B, SW, 3bp+black);
dot("C", C, E, 3bp+black);
dot("D", D, NW, 3bp+black);

// Los ángulos
pen FormAng=fontsize(8pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\widehat{\textup{A}_1}$",FormAng), radius=2mm, B, A, C, FormArc);
markangle(Label("$\widehat{\textup{A}_2}$",FormAng), radius=3mm, C, A, D, FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng), radius=6mm, C, B, A, FormArc);
markangle(Label("$\widehat{\textup{C}_1}$",FormAng), radius=20mm, A, C, B, FormArc);
markangle(Label("$\widehat{\textup{C}_2}$",FormAng), radius=10mm, D, C, A, FormArc);
markangle(Label("$\hat{\textup{D}}$",FormAng), radius=6mm, A, D, C, FormArc);
