//---------------------------------------------------------------
// Fichero:  diagonalescomplejo.asy
// Objetivo: Representar las diagonales de un cuadrilátero complejo
// Fecha:    V.21.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(12,-1), C=(10,3), D=(2,2);

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(A -- B, Punteado+blue);
draw(C -- D, Punteado+blue);

// El cuadrilátero
draw(A -- C -- B -- D -- cycle);

// Los vértices
dot("E", A, SW, 3bp+black);
dot("F", B, E, 3bp+black);
dot("G", C, NE, 3bp+black);
dot("H", D, NW, 3bp+black);
