//---------------------------------------------------------------
// Fichero:  problema3.asy
// Objetivo: Representar el problema 3
// Fecha:    X.9.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que calcula el vértice según los lados
pair PuntoLados(real a, real b, real c)
  {
  path CirIzq = circle((0,0),b);
  path CirDer = circle((a,0),c);
  pair Cortes[] = intersectionpoints(CirIzq, CirDer);
  return Cortes[0];
  }

// Los vértices
pair A=(0,0), C=(65,0);
pair B=PuntoLados(65,16,63);
pair D=PuntoLados(65,56,33);
D=(D.x, -D.y);

// El cuadrilatero
draw(A -- B -- C -- D -- cycle);

// Los ángulos
markrightangle(A, B, C, 0.5bp+gray);
markrightangle(A, D, C, 0.5bp+gray);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, N, 3bp+black);
dot("C", C, E, 3bp+black);
dot("D", D, S, 3bp+black);
