//---------------------------------------------------------------
// Fichero:  enunciado13.asy
// Objetivo: Representar el enunciado 13
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(1.5,1.5), D=(0,4);

// Los ángulos
markrightangle(B, A, D, 5mm, 0.5bp+blue);
markangle(Ang(B,C,D,0), radius=5mm, B, C, D, 0.5bp+blue);
markangle("$\alpha$", radius=10mm, C, B, A, 0.5bp+blue);
markangle("$\alpha$", radius=10mm, A, D, C, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
