//---------------------------------------------------------------
// Fichero:  enunciado12.asy
// Objetivo: Representar el enunciado 12
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,-4), B=(8,0), C=(0,4), D=(-6,0);

// Punto auxiliar
pair H=(3,0);

// Los ángulos
markangle(Ang(A,B,C,0), radius=5mm, C, B, A, 0.5bp+blue);
markangle(Ang(D,A,H,0), radius=5mm, H, A, D, 0.5bp+blue);
markangle(Ang(H,C,D,0), radius=5mm, D, C, H, 0.5bp+blue);
markangle(Ang(C,D,A,1), radius=5mm, A, D, C, 0.5bp+blue);
markangle("$\alpha$", radius=9mm, B, A, H, 0.5bp+blue);
markangle("$\alpha$", radius=9mm, H, C, B, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
draw(C -- H -- A);
